<?php
require('fpdf/rotate.php');

class PDF extends PDF_Rotate
{
// Load data
function LoadData($file)
{
    // Read file lines
    $lines = file($file);
    $data = array();
    foreach($lines as $line)
        $data[] = explode(';',trim($line));
    return $data;
}
function Header(){
    if($this->PageNo()>1){
        $this->writeRecordHeading();
    }

}

function RotatedText($x, $y, $txt, $angle)
{
    //Text rotated around its origin
    $this->Rotate($angle,$x,$y);
    $this->Text($x,$y,$txt);
    $this->Rotate(0);
}


function Footer()
{
    // Position at 1.5 cm from bottom
    $this->SetY(-15);
    // Arial italic 8
    $this->SetFont('Arial','i',6);
    // Page number
    date_default_timezone_set('UTC');
    $this->Cell(0,10,'HMS: Statistics Report  '.date('d-m-Y H:i:s'),0,0,'L');
    $this->Cell(0,10,$this->PageNo().' of {nb}',0,0,'R');
    //$this->SetFont('Arial','B',50);
    //$this->SetAlpha(0.6);
    //$this->SetTextColor(255,142,153);
    //$this->RotatedText(70,190,'D R A F T',45);
    //$this->SetAlpha(1);
    $this->SetFont('Arial','B',6);
}


function writeIntro($vals){

    $this->SetFont('Arial','',14);
    $this->AddPage();
    $this->SetTextColor(128,169,136);
    $this->SetDrawColor(255);
    
    $this->SetFont('','B');
    $this->ln();
    $this->ln();
    $this->Cell(0,10,'HMS: STATISTICS REPORT',0,1,'C');
    $this->SetFont('Arial','B',8);
    $this->SetTextColor(128,169,136);
    $this->Cell(0,10,'SEARCH CRITERIA',0,0,'L');
    $this->Ln(7);
    $this->SetTextColor(255);
    $this->SetFillColor(128,169,136);
    $this->Cell(48,5,'Type/Variant',1,0,'L',true);
    $this->Cell(48,5,'Inspection Version',1,0,'L',true);
    $this->Cell(48,5,'VRN',1,0,'L',true);
    $this->Cell(48,5,'Date',1,0,'L',true);
    $this->Ln(5);
    $this->SetTextColor(0);
    $this->SetFillColor(181,220,185);
    $this->SetFont('Arial','B',8);
    $this->Cell(48,4,$_POST['vehicleid'],'LR',0,'L',true);
    $this->Cell(48,4,$_POST['version'],'LR',0,'L',true);
    $this->Cell(48,4,$_POST['vrn'],'LR',0,'L',true);  
    $this->Cell(48,4,$_POST['date'],'LR',0,'L',true);

    $this->Ln(7);

    $this->SetTextColor(255);
    $this->SetFillColor(128,169,136);
    $this->Cell(48,5,'Interval',1,0,'L',true);
    $this->Cell(48,5,'Unit/Location',1,0,'L',true);
    $this->Cell(48,5,'Status',1,0,'L',true);
    $this->Cell(48,5,'Completed',1,0,'L',true);
    $this->Ln(5);
    $this->SetTextColor(0);
    $this->SetFillColor(181,220,185);
    $this->SetFont('Arial','B',8);
    $this->Cell(48,4,$_POST['interval'],'LR',0,'L',true);
    $this->Cell(48,4,$_POST['unit'],'LR',0,'L',true);
    $this->Cell(48,4,$_POST['status'],'LR',0,'L',true);  
    $this->Cell(48,4,$_POST['completed'],'LR',0,'L',true);

    $this->Ln(7);
    $this->SetFont('Arial','B',8);
    $this->SetTextColor(128,169,136);
    $this->Cell(0,10,'RESULTS',0,0,'L');
    $this->Ln(7);
    $this->writeRecordHeading();
}

function writeRecordHeading(){

    $this->SetFont('Arial','B',6);
    $this->SetTextColor(0);
    $this->SetFillColor(181,220,185);
    $this->SetDrawColor(0);
    $this->Cell(29,7,'SSI FM Ref','LRT',0,'L',true);
    $this->Cell(41,7,'SSI FM Name','LRT',0,'L',true);
    $this->Cell(29,7,'SSI Location','LRT',0,'L',true);
    $this->Cell(21,7,'Flaw','LRT',0,'L',true);
    $this->Cell(29,7,'Qty(%) Vehicles','LRT',0,'L',true);
    $this->Cell(21,7,'Max Flaw','LRT',0,'L',true);
    $this->Cell(21,7,'Average Flaw','LRT',0,'L',true);
    $this->Ln(5);
    $this->Cell(29,5,'','LRB',0,'L',true);
    $this->Cell(41,5,'','LRB',0,'L',true);
    $this->Cell(29,5,'','LRB',0,'L',true);
    $this->Cell(21,5,'Occurrence','LRB',0,'L',true);
    $this->Cell(29,5,'with Flaw','LRB',0,'L',true);
    $this->Cell(21,5,'Size (mm)','LRB',0,'L',true);
    $this->Cell(21,5,'Size (mm)','LRB',0,'L',true);
        $this->Ln(5);
}


}

$pdf = new PDF();
$pdf->AliasNbPages();
//$vals=json_decode($json,true);
$pdf->writeIntro($_POST);
$pdf->SetFont('Arial','B',6);
$pdf->SetTextColor(0);
$pdf->SetFillColor(255);
$pdf->SetDrawColor(0);
$pdf->tablewidths = array(29, 41, 29, 21, 29, 21, 21);
for($i=0;$i<count($_POST['ref']);$i++) {
    $data[] = array($_POST['ref'][$i], $_POST['title'][$i], $_POST['location'][$i],$_POST['occurance'][$i], $_POST['qty'][$i], $_POST['max'][$i],$_POST['average'][$i]);
}
$pdf->morepagestable($data,3);

$pdf->Output();
?>